﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CashierCrisis.Entities;
using Microsoft.Xna.Framework;

namespace CashierCrisis.Behaviors
{
    public class Move : Action
    {

        public Vector2 Destination { get; set; }

        public override Status Execute(Microsoft.Xna.Framework.GameTime gameTime)
        {
            SteeringComponent steering = Entity.GetComponent("steering") as SteeringComponent;

            if (ReachedDestination())
            {
                steering.ToggleSteeringBehavior(SteeringBehavior.Arrive, false);
                return Completed;
            }
            else
            {
                
                steering.TargetPosition = Destination;
                steering.ToggleSteeringBehavior(SteeringBehavior.Arrive, true);

                return Running;
            }
        }

        public bool ReachedDestination()
        {
            Vector2 toTarget = Destination - Entity.Position;

            return toTarget.Length() <= 0.9;
        }
    }
}
